/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright        2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUFile.h
//
//	Description:
//		File utilities for alias values acquired from the automation system.
//
//	Version history:
//		Version 1.0.0	7/10/2000	Created for Photoshop 6.0.
//			Written by Thomas Ruark.
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#ifndef __PIUFile__
#define __PIUFile__

#include "PIDefines.h"
#include "PITypes.h"
#include "PIGeneral.h"
#include "SPBasic.h"
#include "PIHandleSuite.h"
#ifdef __PIMac__
	#include <string.h>
	#include <stdio.h>
#endif

extern PSHandleSuite1* sPSHandle;

void AliasToFullPath(Handle aliasValue, char* fullPath);
void FullPathToAlias(char* fullPath, Handle& aliasValue);

#endif